#Load Assembly
Add-Type -AssemblyName System.Windows.Forms.DataVisualization
 
# chart object

$chart1 = New-object System.Windows.Forms.DataVisualization.Charting.Chart
$chart1.Width = 500
$chart1.Height = 450
$chart1.BackColor = [System.Drawing.Color]::white
 
# title 
   [void]$chart1.Titles.Add("Virtual CPU Count")
   $chart1.Titles[0].Font = "Arial,13pt"
   $chart1.Titles[0].Alignment = "topLeft"
 
# chart area 
   $chartarea = New-Object System.Windows.Forms.DataVisualization.Charting.ChartArea
   $chartarea.Name = "ChartArea1"
   $chartarea.AxisY.Title = "Virtual CPU Count"
   $chartarea.AxisX.Title = "Virtual Servers"
   $chartarea.AxisY.Interval = 1
   $chartarea.AxisX.Interval = 1
   $chart1.ChartAreas.Add($chartarea)
 
# legend 
   $legend = New-Object system.Windows.Forms.DataVisualization.Charting.Legend
   $legend.name = "Legend1"
   $chart1.Legends.Add($legend)
 
# data source 1

$VMs = Get-VM -ComputerName HyperV
ForEach ($VM in $VMs){
	$CPU = Get-VMProcessor $VM.Name
	$DataSource1 = $DataSource1 + @{$VM.Name = $CPU.Count}
	} 


# Data Series 1
   [void]$chart1.Series.Add("CPU Count")
   $chart1.Series["CPU Count"].ChartType = "Bar"
   $chart1.Series["CPU Count"].BorderWidth  = 3
   $chart1.Series["CPU Count"].IsVisibleInLegend = $true
   $chart1.Series["CPU Count"].chartarea = "ChartArea1"
   $chart1.Series["CPU Count"].Legend = "Legend1"
   $chart1.Series["CPU Count"].color = "Blue" 
   $Chart1.Series["CPU Count"].Points.DataBindXY($DataSource1.keys, $DataSource1.Values)

# Data Source 2

$VMs = Get-VM -ComputerName HyperV
ForEach ($VM in $VMs){
	$CpuUse = Measure-VM $VM.Name
	$DataSource2 = $DataSource2 + @{$VM.Name = ($CpuUse.AvgCPU /10)}
	} 

# Data Series 2
   [void]$chart1.Series.Add("CPU Use")
   $chart1.Series["CPU Use"].ChartType = "Bar"
   $chart1.Series["CPU Use"].BorderWidth  = 3
   $chart1.Series["CPU Use"].IsVisibleInLegend = $true
   $chart1.Series["CPU Use"].chartarea = "ChartArea1"
   $chart1.Series["CPU Use"].Legend = "Legend1"
   $chart1.Series["CPU Use"].color = "Red" 
   $Chart1.Series["CPU Use"].Points.DataBindXY($DataSource2.keys, $DataSource2.Values)

# display the chart on a form 

$Form = New-Object Windows.Forms.Form 
$Form.Text = "Virtual CPU Count" 
$Form.Width = 500 
$Form.Height = 500 
$Form.controls.add($Chart1) 
$Form.Add_Shown({$Form.Activate()}) 
$Form.ShowDialog()
