#Load Assembly
Add-Type -AssemblyName System.Windows.Forms.DataVisualization
 
# chart object

$chart1 = New-object System.Windows.Forms.DataVisualization.Charting.Chart
$chart1.Width = 500
$chart1.Height = 450
$chart1.BackColor = [System.Drawing.Color]::white
 
# title 
   [void]$chart1.Titles.Add("Virtual CPU Count")
   $chart1.Titles[0].Font = "Arial,13pt"
   $chart1.Titles[0].Alignment = "topLeft"
 
# chart area 
   $chartarea = New-Object System.Windows.Forms.DataVisualization.Charting.ChartArea
   $chartarea.Name = "ChartArea1"
   $chartarea.AxisY.Title = "Virtual CPU Count"
   $chartarea.AxisX.Title = "Virtual Servers"
   $chartarea.AxisY.Interval = 1
   $chartarea.AxisX.Interval = 1
   $chart1.ChartAreas.Add($chartarea)
 
# legend 
   $legend = New-Object system.Windows.Forms.DataVisualization.Charting.Legend
   $legend.name = "Legend1"
   $chart1.Legends.Add($legend)
 
# data source

# $DataSource1 = $DataSource1 = @{Red=5; Blue=9; Green=7; Yellow=2; Purple=6} 

$VMs = Get-VM -ComputerName HyperV
ForEach ($VM in $VMs){
	$CPU = Get-VMProcessor $VM.Name
	$DataSource1 = $DataSource1 + @{$VM.Name = $CPU.Count}
	} 


# Sample data series
   [void]$chart1.Series.Add("Virtual CPU")
   $chart1.Series["Virtual CPU"].ChartType = "Bar"
   $chart1.Series["Virtual CPU"].BorderWidth  = 3
   $chart1.Series["Virtual CPU"].IsVisibleInLegend = $true
   $chart1.Series["Virtual CPU"].chartarea = "ChartArea1"
   $chart1.Series["Virtual CPU"].Legend = "Legend1"
   $chart1.Series["Virtual CPU"].color = "Blue" 
   $Chart1.Series["Virtual CPU"].Points.DataBindXY($DataSource1.keys, $DataSource1.Values)


# display the chart on a form 

$Form = New-Object Windows.Forms.Form 
$Form.Text = "Virtual CPU Count" 
$Form.Width = 500 
$Form.Height = 500 
$Form.controls.add($Chart1) 
$Form.Add_Shown({$Form.Activate()}) 
$Form.ShowDialog()
