#Load Assembly
Add-Type -AssemblyName System.Windows.Forms.DataVisualization
 
# chart object

$chart1 = New-object System.Windows.Forms.DataVisualization.Charting.Chart
$chart1.Width = 500
$chart1.Height = 450
$chart1.BackColor = [System.Drawing.Color]::white
#Background can be any color or transparent
 
# title 
   
[void]$chart1.Titles.Add("Widget Sales")
$chart1.Titles[0].Font = "Arial,13pt"
$chart1.Titles[0].Alignment = "topLeft"
 
# chart area 

$chartarea = New-Object System.Windows.Forms.DataVisualization.Charting.ChartArea
$chartarea.Name = "ChartArea1"
$chartarea.AxisY.Title = "Price"
$chartarea.AxisX.Title = "Number Sold"
$chartarea.AxisY.Interval = 1
$chartarea.AxisX.Interval = 1
$chart1.ChartAreas.Add($chartarea)
# $ChartArea.Area3DStyle.Enable3D=$True
# $ChartArea.Area3DStyle.Inclination = 50
 
# legend 

$legend = New-Object system.Windows.Forms.DataVisualization.Charting.Legend
$legend.name = "Legend"
$chart1.Legends.Add($legend)
 
# data source

$DataSource1 = @{Red=5; Blue=9; Green=7; Yellow=2; Purple=6} 

# Sample data series
[void]$chart1.Series.Add("Widget Sales")
$chart1.Series["Widget Sales"].ChartType = "Column"
# $chart1.Series["Widget Sales"].ChartType = "Bar"
# $chart1.Series["Widget Sales"].ChartType = "line"
# $chart1.Series["Widget Sales"]["DrawingStyle"] = "Cylinder"


# Pie Chart

# $chart1.Series["Widget Sales"].ChartType = "Pie"
# $Chart1.Series["Widget Sales][PieLabelStyle] = "Inside 
# $Chart1.Series["Widget Sales][PieLineColor] = Black 
# $Chart1.Series["Widget Sales][PieDrawingStyle] = Concave

# Data Series

$chart1.Series["Widget Sales"].BorderWidth  = 3
$chart1.Series["Widget Sales"].IsVisibleInLegend = $true
$chart1.Series["Widget Sales"].chartarea = "ChartArea1"
$chart1.Series["Widget Sales"].Legend = "Legend"
$chart1.Series["Widget Sales"].color = "Blue" 
$Chart1.Series["Widget Sales"].Points.DataBindXY($DataSource1.keys, $DataSource1.Values)


# display the chart on a form 

$Form = New-Object Windows.Forms.Form 
$Form.Text = "PowerShell Chart" 
$Form.Width = 500 
$Form.Height = 500 
$Form.controls.add($Chart1) 
$Form.Add_Shown({$Form.Activate()}) 
$Form.ShowDialog()

#Save the Chart
# $Chart1.SaveImage('C:\Scripts\chart.jpeg', 'jpeg')
