Function Display-Output
	{
	Process {
  	$obj = New-Object PSObject
  	$obj | Add-Member NoteProperty "VM Name"($_.Name)
	$CPU = Get-VMProcessor ($_.Name) -ComputerName HyperV
  	$obj | Add-Member NoteProperty "CPU Count"($CPU.Count)
  	$obj | Add-Member NoteProperty "Maximum"($CPU.Maximum)
	$obj | Add-Member NoteProperty "Reserve"($CPU.Reserve)
  	Write-Output $obj 
	}  
	}

$VMs = Get-VM -ComputerName HyperV

# Header code adapted from: https://technet.microsoft.com/en-us/library/ff730936.aspx 
# Color names are available at: http://www.w3schools.com/colors/colors_names.asp 

$a = "<style>"
$a = $a + "BODY{background-color:DarkSeaGreen;}"
$a = $a + "TABLE{border-width: 1px;border-style: solid;border-color: black;border-collapse: collapse;}"
$a = $a + "TH{border-width: 1px;padding: 5px;border-style: solid;border-color: black;background-color:tan}"
$a = $a + "TD{border-width: 1px;padding: 5px;border-style: solid;border-color: black;background-color:WhiteSmoke}"
$a = $a + "</style>"

@($VMs) | Display-Output | ConvertTo-HTML -Head $a -Body "<H2>Virtual CPU Information<H2>"| Out-File C:\Data\7-5.htm
