Function Display-Output ($VM, $CPU)
	{
  	$obj = New-Object PSObject
  	$obj | Add-Member NoteProperty "VM Name"($VM.Name)
  	$obj | Add-Member NoteProperty "CPU Count"($CPU.Count)
  	$obj | Add-Member NoteProperty "Maximum"($CPU.Maximum)
	$obj | Add-Member NoteProperty "Reserve"($CPU.Reserve)
  	Write-Output $obj
	}  
$VMs = Get-VM -ComputerName HyperV

ForEach ($VM in $VMs){
		$CPU = Get-VMProcessor $VM.Name -ComputerName HyperV
		Display-Output $VM $CPU | Export-CSV -Path C:\Data\7-2.csv -NoTypeInformation -append
		}

