#   Written by: Brien M. Posey
#   Developed: January 23, 2022
#   Last Updated: January 23, 2022
#   Purpose: Demonstration of PowerShell coding techniques





#------ Begin Get-MyVMs Function -------

Function Get-MyVMs($Server){

#Function retrieves a list of VMs from the server 
#that is specified in the $Server variable

$VMs = Get-VM -ComputerName $Server
$VMs | Select-Object Name | Format-List
}
# ---- End of Get-MyVMs Function





# ---- Script Body -----

# Variables

$Server=$Null # The $Server variable will store the name of a Hyper-V server.
$VMs = $Null  # The $VMs variable stores a list of virtual machines

# ----Script Logic Begins Here----
$Server="HyperV"
Get-MyVMs $Server




