#Load Assemblies
[System.Reflection.Assembly]::LoadWithPartialName("System.Windows.Forms") | Out-Null
[System.Reflection.Assembly]::LoadWithPartialName("System.Drawing") | Out-Null


# -----Display the Main Screen-------

Function Display-MainScreen
{
$Form.Controls.Add($ListBox1)
$Form.Controls.Add($Button1)
$Form.Controls.Add($Button2)
$Form.Controls.Add($Label1)
}




# ---------- Return Button Click Action ------

Function Return-MainScreen
	{
	$Form.Controls.Remove($Outputbox)
	$Form.Controls.Remove($Label2)
	$Form.Controls.Remove($Button3)

	$Form.Refresh()
	Display-MainScreen
	}


# ----------OK Button Click Action---------

Function Display-VMInfo($ChosenItem)
{

#Clear the window
$Form.Controls.Remove($ListBox1)
$Form.Controls.Remove($Label1)
$Form.Controls.Remove($Button1)
$Form.Controls.Remove($Button2)
$Form.Refresh()

Add-Type -AssemblyName System.Windows.Forms 

# Get Virtual Machine Information

$SelectedVM = Get-VM -ComputerName HyperV $ChosenItem
$Name = $SelectedVM.VMName
$State = $SelectedVM.State
$RunTime = $SelectedVM.UpTime
$Memory = $SelectedVM.MemoryAssigned
$CPU = $SelectedVM.ProcessorCount


#Create text

###### Important: Using apostrophes instead of quotation marks breaks the new line code.

$Outputbox.text= "VM State: " + $State + "`r`nVM Up Time: " + $RunTime + "`r`n" + "Memory Assigned: " + $Memory + "`r`n" + "Virtual CPUs Assigned: " + $CPU
$Label2.Text = "Your selected virtual machine: " + $ChosenItem

#Display Text

$Form.Controls.Add($Label2)
$Form.Controls.Add($outputBox)
$Form.Controls.Add($Button3)

}





#------ Define All GUI Objects-------

# Define Label2 - The Please Make a Selection Text
$Label1 = New-Object System.Windows.Forms.Label
$Label1.AutoSize = $True
$Label1.Location = new-object System.Drawing.Size(20,50)
$Label1.ForeColor = "Black"
$Label1.Text = "Please select a virtual machine from the list."


# Define Label3 - The This is Your Selected Virtual Machine Text
$Label2 = New-Object System.Windows.Forms.Label
$Label2.AutoSize = $True
$Label2.Location = new-object System.Drawing.Size(10,10)
$Label2.ForeColor = "Black"
$Label2.Text = "Your selected virtual machine:"



#Define Output Box
$outputBox = New-Object System.Windows.Forms.TextBox 
$outputBox.Location = New-Object System.Drawing.Size(10,30) 
$outputBox.Size = New-Object System.Drawing.Size(200,100) 
$outputBox.MultiLine = $True
$outputBox.ScrollBars = "Vertical"

# Define List Box - This will display the virtual machines that can be selected
$ListBox1 = New-Object System.Windows.Forms.ListBox 
$ListBox1.Location = New-Object System.Drawing.Size(20,80) 
$ListBox1.Size = New-Object System.Drawing.Size(260,20) 
$ListBox1.Height = 80

	# This code populates the list box with virtual machine names
	$VirtualMachines = Get-VM -ComputerName HyperV
	ForEach ($VM in $VirtualMachines)
		{
		[void] $ListBox1.Items.Add($VM.Name)
		}


# Define Button 1  - This is the selection screen's OK button
$Button1 = new-object System.Windows.Forms.Button
$Button1.Location = new-object System.Drawing.Size(20,170) 
$Button1.Size = new-object System.Drawing.Size(70,30)
$Button1.BackColor ="LightGray"
$Button1.Text = "OK"
$Button1.Add_Click({$ChosenItem=$ListBox1.SelectedItem;Display-VMInfo $ChosenItem})


# Define Button 2 - This is the selection screen's Cancel button
$Button2 = New-Object System.Windows.Forms.Button
$Button2.Location = New-Object System.Drawing.Size(120,170)
$Button2.Size = New-Object System.Drawing.Size(70,30)
$Button2.BackColor ="LightGray"
$Button2.Text = "Cancel"
$Button2.Add_Click({$Form.Close()})


# Define Button 3 - This is the Return to Main Screen button
$Button3 = New-Object System.Windows.Forms.Button
$Button3.Location = New-Object System.Drawing.Size(50,150)
$Button3.Size = New-Object System.Drawing.Size(70,30)
$Button3.BackColor ="LightGray"
$Button3.Text = "Return"
$Button3.Add_Click({Return-MainScreen})


# -------- This is the end of the object definition section ------



# -----Draw the empty form----
$Form = New-Object System.Windows.Forms.Form
$Form.width = 400
$Form.height = 350

# $Form.BackColor = "LightGray"

$Form.FormBorderStyle = [System.Windows.Forms.FormBorderStyle]::Fixed3D
$Form.Text = "Hyper-V Virtual Machines"
$Form.maximumsize = New-Object System.Drawing.Size(525,350)
$Form.startposition = "centerscreen"
$Form.KeyPreview = $True
$Form.Add_KeyDown({if ($_.KeyCode -eq "Enter") {}})
 $Form.Add_KeyDown({if ($_.KeyCode -eq "Escape") 
     {$Form.Close()}})

#----Populate the form----
Display-MainScreen
$Form.Add_Shown({$Form.Activate()})
$Form.ShowDialog()
